#include "ocl.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
 
#define PI 3.14159265358979

int n_var(int nproblem, char *fname, double *lower, double *upper, double *opt)
{
	int nvar;

	switch(nproblem) 
	{
		/* Functions with 2 variables */

		case  1: strcpy(fname,"Branin");*opt=0.397887;
				 nvar=2;  *lower=-5; *upper=15; break;

		case  2: strcpy(fname,"B2");*opt=0;
				 nvar=2;  *lower=-50; *upper=100; break;

		case  3: strcpy(fname,"Easom");*opt=-1;
				 nvar=2;  *lower=-100; *upper=100; break;

		case  4: strcpy(fname,"Goldstein and Price");*opt=3;
				 nvar=2;  *lower=-2; *upper=2; break;

		case  5: strcpy(fname,"Shubert");*opt=-186.7309;
				 nvar=2;  *lower=-10; *upper=10; break;

		case  6: strcpy(fname,"Beale1");*opt=0;
				 nvar=2;  *lower=-4.5; *upper=4.5;  break;

		case  7: strcpy(fname,"Booth");*opt=0;
				 nvar=2;  *lower=-10; *upper=10;  break;

		case  8: strcpy(fname,"Matyas");*opt=0;
				 nvar=2;  *lower=-5; *upper=10;  break;
		
		case  9: strcpy(fname,"SixHumpCamelBack");*opt=-1.0316285;
				 nvar=2;  *lower=-5; *upper=5;  break;

		case 10: strcpy(fname,"Schwefel(2)");*opt=0;
				 nvar=2;  *lower=-500; *upper=500; break;
		
		case 11: strcpy(fname,"Rosenbrock(2)");*opt=0;
				 nvar=2;  *lower=-10; *upper=10;  break;

		case 12: strcpy(fname,"Zakharov(2)");*opt=0;
				 nvar=2;  *lower=-5; *upper=10;  break;

		/* Functions with 3 variables */

		case 13: strcpy(fname,"De Joung");*opt=0;
				 nvar=3;  *lower=-2.56; *upper=5.12; break;

	
		case 14: strcpy(fname,"Hartman");*opt=-3.86278;
				 nvar=3;  *lower=0; *upper=1; break;

		/* Functions with 4 variables */

		case 15: strcpy(fname,"Colville"); *opt=0;
				 nvar=4;  *lower=-10;  *upper=10; break;

		case 16: strcpy(fname,"Shekel(5)");*opt=-10.1532;
				 nvar=4;  *lower=0; *upper=10; break;

		case 17: strcpy(fname,"Shekel(7)");*opt=-10.40294;
				 nvar=4;  *lower=0; *upper=10; break;

		case 18: strcpy(fname,"Shekel(10)");*opt=-10.53641;
				 nvar=4;  *lower=0; *upper=10; break;

		case 19: strcpy(fname,"Perm(4,0.5)");*opt=0;
				 nvar=4;  *lower=-4;   *upper=4;	 break;

		case 20: strcpy(fname,"Perm0(4,10)");*opt=0;
				 nvar=4;  *lower=-4;   *upper=4;	 break;

		case 21: strcpy(fname,"Powersum(8,18,44,114)");*opt=0;
				 nvar=4;  *lower=0;    *upper=4;	 break;

		/* Functions with 6 variables */

		case 22: strcpy(fname,"Hartman(6,4)");*opt=-3.32237;
				 nvar=6;  *lower=0; *upper=1; break;

		case 23: strcpy(fname,"Schwefel(6)");*opt=0;
				 nvar=6;  *lower=-500; *upper=500; break;

		case 24: strcpy(fname,"Trid(6)");*opt=-50;
				 nvar=6;  *lower=-36;  *upper=36; break;

		/* Functions with 10 variables */

		case 25: strcpy(fname,"Trid(10)");*opt=-210;
				 nvar=10;  *lower=-100; *upper=100;  break;

		case 26: strcpy(fname,"Rastrigin(10)");*opt=0;
				 nvar=10;  *lower=-2.56; *upper=5.12; break;

		case 27: strcpy(fname,"Griewank(10)");*opt=0;
				 nvar=10;  *lower=-300; *upper=600; break;

		case 28: strcpy(fname,"Sum Squares(10)");*opt=0;
				 nvar=10;  *lower=-5; *upper=10; break;

		case 29: strcpy(fname,"Rosenbrock(10)");*opt=0;
				 nvar=10;  *lower=-10; *upper=10;  break;

		case 30: strcpy(fname,"Zakharov(10)");*opt=0;
				 nvar=10;  *lower=-5; *upper=10;  break;

		/* Functions with 20 variables */

		case 31: strcpy(fname,"Rastrigin(20)");*opt=0;
				 nvar=20;  *lower=-2.56; *upper=5.12; break;

		case 32: strcpy(fname,"Griewank(20)");*opt=0;
				 nvar=20;  *lower=-300; *upper=600; break;

		case 33: strcpy(fname,"Sum Squares(20)");*opt=0;
				 nvar=20;  *lower=-5; *upper=10; break;

		case 34: strcpy(fname,"Rosenbrock(20)");*opt=0;
				 nvar=20;  *lower=-10; *upper=10;  break;

		case 35: strcpy(fname,"Zakharov(20)");*opt=0;
				 nvar=20;  *lower=-5; *upper=10;  break;

		/* Functions with more than 20 variables */

		case 36: strcpy(fname,"Powell(24)");*opt=0;
				 nvar=24;  *lower=-4; *upper=5; break;

		case 37: strcpy(fname,"Dixon and Price");*opt=0;
				 nvar=25;  *lower=-10; *upper=10; break;

		case 38: strcpy(fname,"Levy(30)");*opt=0;
				 nvar=30;  *lower=-10; *upper=10;  break;

		case 39: strcpy(fname,"Sphere(30)");*opt=0;
				 nvar=30;  *lower=-2.56; *upper=5.12; break;

		case 40: strcpy(fname,"Ackley(30)");*opt=0;
				 nvar=30;  *lower=-15; *upper=30; break;
	}
	return nvar;
}

double evaluate(int nproblem,int nvar,double *x)    
{
	double value,value2,beta,a,b[50],z[50];
	double ab[12][12],c[12],p[12][12];
	int k,i,j,n;

	switch(nproblem)
	{
		case  1: // Branin
			value = pow(x[2]-(5/(4*PI*PI))*pow(x[1],2)+(5/PI)*x[1]-6,2);
			value += 10*cos(x[1])*(1-(1/(8*PI)))+10;
		break;

		case  2: // B2
			value = pow(x[1],2)+2*pow(x[2],2)-0.3*cos(3*PI*x[1])-0.4*cos(4*PI*x[2])+0.7;
		break;

		case  3: // Easom
			value = -cos(x[1])*cos(x[2])*exp(-pow(x[1]-PI,2)-pow(x[2]-PI,2));
		break;

		case  4: // Goldstein and Price
			value = 1+pow(x[1]+x[2]+1,2)*(19-14*x[1]+3*pow(x[1],2)-14*x[2]+
					6*x[1]*x[2]+3*pow(x[2],2));
			value2 = 30+pow(2*x[1]-3*x[2],2)*(18-32*x[1]+12*pow(x[1],2)+48*x[2]
				    -36*x[1]*x[2]+27*pow(x[2],2));
			value = value * value2;
		break;

		case  5:  // Shubert
			value=value2=0;
			for(i=1;i<=5;i++)
			{
				value  += i*cos((i+1)*x[1]+i);
				value2 += i*cos((i+1)*x[2]+i);
			}
			value *= value2;
		break;

		case  6: // Beale
			value=pow(1.5-x[1]+x[1]*x[2],2)+pow(2.25-x[1]+x[1]*pow(x[2],2),2)+
				  pow(2.625-x[1]+x[1]*pow(x[2],3),2);
		break;

		case  7: // Booth
			value=pow(x[1]+2*x[2]-7,2)+pow(2*x[1]+x[2]-5,2);
		break;

		case  8: // Matyas
			value=0.26*(pow(x[1],2)+pow(x[2],2))-0.48*x[1]*x[2] ;
		break;

		case  9: // Six Hump Camel Back
			value=4*pow(x[1],2)-2.1*pow(x[1],4)+pow(x[1],6)/3+x[1]*x[2]
				  -4*pow(x[2],2)+4*pow(x[2],4);
		break;
		
		case 10:  // Schwefel
		case 23:
			value=418.9829*nvar;
			for(i=1;i<=nvar;i++) value += -x[i]*sin(sqrt(fabs(x[i])));
		break;

		case 11: // Rosenbrock
		case 29:
		case 34:
			value=0;
			for(i=1;i<=nvar/2.0;i++) 
				value += 100*pow( x[2*i]-pow(x[(2*i)-1],2), 2)+
							 pow(1-x[(2*i)-1],2);
		break;
		
		case 12: // Zakharov
		case 30:
		case 35:
			value=0;
			for(i=1;i<=nvar;i++) value += pow(x[i],2);

			value2=0;
			for(i=1;i<=nvar;i++) value2 += 0.5*i*x[i];
			value += pow(value2,2);

			value2=0;
			for(i=1;i<=nvar;i++) value2 += 0.5*i*x[i];
			value += pow(value2,4);
		break;

		case 13: // De Joung
			value=pow(x[1],2)+pow(x[2],2)+pow(x[3],2);
		break;

		case 14: // Hartman(3,4)
			ab[1][1]=3;  ab[1][2]=10;ab[1][3]=30;
			ab[2][1]=0.1;ab[2][2]=10;ab[2][3]=35;
			ab[3][1]=3;  ab[3][2]=10;ab[3][3]=30;
			ab[4][1]=0.1;ab[4][2]=10;ab[4][3]=35;

			c[1]=1; c[2]=1.2; c[3]=3.0; c[4]=3.2;

			p[1][1]=0.3689; p[1][2]=0.1170; p[1][3]=0.2673;
			p[2][1]=0.4699; p[2][2]=0.4387; p[2][3]=0.7470;
			p[3][1]=0.1091; p[3][2]=0.8732; p[3][3]=0.5547;
			p[4][1]=0.0381; p[4][2]=0.5743; p[4][3]=0.8828;

			value = 0;
			for(i=1;i<=4;i++)
			{
				value2=0;
				for(j=1;j<=3;j++)
					value2 += ab[i][j]*pow(x[j]-p[i][j],2);
				value += c[i]*exp(-value2);
			}
			value *= -1;
		break;

		case 15: // Colville
			value = 100*pow(x[2]-pow(x[2],2),2)+pow(1-x[1],2)+90*pow(x[4]-pow(x[3],2),2)+
				    pow(1-x[3],2)+10.1*pow(x[2]-1,2)+10.1*pow(x[4]-1,2)+19.8*(x[2]-1)*(x[4]-1);
		break;

		case 16: // Shekel
		case 17:
		case 18:
			if(nproblem==16) n=5;
			if(nproblem==17) n=7;
			if(nproblem==18) n=10;

			ab[1][1]=4; ab[1][2]=4; ab[1][3]=4; ab[1][4]=4;
			ab[2][1]=1; ab[2][2]=1; ab[2][3]=1; ab[2][4]=1;
			ab[3][1]=8; ab[3][2]=8; ab[3][3]=8; ab[3][4]=8;
			ab[4][1]=6; ab[4][2]=6; ab[4][3]=6; ab[4][4]=6;
			ab[5][1]=3; ab[5][2]=7; ab[5][3]=3; ab[5][4]=7;
			ab[6][1]=2; ab[6][2]=9; ab[6][3]=2; ab[6][4]=9;
			ab[7][1]=5; ab[7][2]=5; ab[7][3]=3; ab[7][4]=3;
			ab[8][1]=8; ab[8][2]=1; ab[8][3]=8; ab[8][4]=1;
			ab[9][1]=6; ab[9][2]=2; ab[9][3]=6; ab[9][4]=2;
			ab[10][1]=7; ab[10][2]=3.6; ab[10][3]=7; ab[10][4]=3.6;

			c[1]=0.1; c[2]=0.2; c[3]=0.2; c[4]=0.4; c[5]=0.4;
			c[6]=0.6; c[7]=0.3; c[8]=0.7; c[9]=0.5; c[10]=0.5;

			value=0;
			for(i=1;i<=n;i++)
			{
				value2=0;
				for(j=1;j<=4;j++)
					value2 += pow(x[j]-ab[i][j],2);
				value2 += c[i];
				value += 1/value2;
			}
			value *= -1;
		break;

		case 19: // Perm(4,0.5)
			beta=0.5;value=0;
			for(k=1;k<=nvar;k++) {
				a=0; for(i=1;i<=nvar;i++) a+=(pow(i,k)+beta)*(pow(x[i]/(float)i,k)-1);
				value += pow(a,2);
			}
		break;

		case 20:  // Perm0(4,10)
			beta=10;value=0;
			for(k=1;k<=nvar;k++) {
				a=0; for(i=1;i<=nvar;i++) a+=(i+beta)*(pow(x[i],k)-pow(1/(float)i,k));
				value += pow(a,2);
			}
		break;

		case 21:  // Powersum(8,18,44,114)
			b[1]=8;b[2]=18;b[3]=44;b[4]=114;
			value=0;
			for(k=1;k<=nvar;k++) {
				a=0; for(i=1;i<=nvar;i++) a+=pow(x[i],k);
				value += pow(a-b[k],2);
			}
		break;

		case 22: // Hartman(6,4)
			ab[1][1]=10;  ab[1][2]=3;  ab[1][3]=17;  ab[1][4]=3.5; ab[1][5]=1.7;ab[1][6]=8;
			ab[2][1]=0.05;ab[2][2]=10; ab[2][3]=17;  ab[2][4]=0.1; ab[2][5]=8;  ab[2][6]=14;
			ab[3][1]=3;   ab[3][2]=3.5;ab[3][3]=1.7; ab[3][4]=10;  ab[3][5]=17; ab[3][6]=8;
			ab[4][1]=17;  ab[4][2]=8;  ab[4][3]=0.05;ab[4][4]=10;  ab[4][5]=0.1;ab[4][6]=14;

			c[1]=1; c[2]=1.2; c[3]=3.0; c[4]=3.2;

			p[1][1]=0.1312; p[1][2]=0.1696; p[1][3]=0.5569; p[1][4]=0.0124; p[1][5]=0.8283; p[1][6]=0.5886;
			p[2][1]=0.2329; p[2][2]=0.4135; p[2][3]=0.8307; p[2][4]=0.3736; p[2][5]=0.1004; p[2][6]=0.9991;
			p[3][1]=0.2348; p[3][2]=0.1451; p[3][3]=0.3522; p[3][4]=0.2883; p[3][5]=0.3047; p[3][6]=0.6650;
			p[4][1]=0.4047; p[4][2]=0.8828; p[4][3]=0.8732; p[4][4]=0.5743; p[4][5]=0.1091; p[4][6]=0.0381;

			value = 0;
			for(i=1;i<=4;i++)
			{
				value2=0;
				for(j=1;j<=6;j++)
					value2 += ab[i][j]*pow(x[j]-p[i][j],2);
				value += c[i]*exp(-value2);
			}
			value *= -1;
		break;

		case 24:  // Trid
		case 25:
			value=0;
			for(i=1;i<=nvar;i++) value += pow(x[i]-1,2);
			for(i=2;i<=nvar;i++) value -= x[i]*x[i-1];
		break;
		
		case 26:  // Rastrigin
		case 31:
			value=10*nvar;
			for(i=1;i<=nvar;i++) value += pow(x[i],2) - 10*cos(PI*2*x[i]);
		break;

		case 27: // Griewank
		case 32:
			value=1;  for(i=1;i<=nvar;i++) value  += pow(x[i],2)/4000;
			value2=1; for(i=1;i<=nvar;i++) value2 *= cos(x[i]/sqrt(i));
			value -= value2;
		break;

		case 28: // Sum Squares
		case 33:
			value=0;  for(i=1;i<=nvar;i++) value += i*pow(x[i],2);
		break;

		case 36: // Powell
			value=0;
			for(i=1;i<=nvar/4;i++)
				value += pow(x[4*i-3]+10*x[4*i-2],2)+5*pow(x[4*i-1]-x[4*i],2)+
						 pow(x[4*i-2]-2*x[4*i-1],4)+10*pow(x[4*i-3]-x[4*i],4);
		break;

		case 37: // Dixon and Price
			value=pow(x[1]-1,2);
			for(i=2;i<=nvar;i++) value += i*pow(2*pow(x[i],2)-x[i-1],2);
		break;

		case 38: // Levy
			for(i=1;i<=nvar;i++) z[i] = 1+(x[i]-1)/4;
			value=pow(sin(PI*z[1]),2);
			for(i=1;i<=nvar-1;i++)
				value += pow(z[i]-1,2)*(1+10*pow(sin(PI*z[i]+1),2));
			value += pow(z[nvar]-1,2)*(1+pow(sin(2*PI*z[nvar]),2));
		break;
		
		case 39:  // Sphere
			value=0;
			for(i=1;i<=nvar;i++)
				value += pow(x[i],2);
		break;

		case 40:  // Ackley
			b[1]=0; for(i=1;i<=nvar;i++) b[1] += pow(x[i],2);
			b[2]=0; for(i=1;i<=nvar;i++) b[2] += cos(2*PI*x[i]);

			value = 20+exp(1)-20*exp(-0.2*sqrt(b[1]/(float)nvar))-exp(b[2]/(float)nvar);
		break;
	}
	return value;
}